
IF OBJECT_ID('UFD_EST_PROD_TBL_DESC_CONV_COMMERCE') IS NOT NULL
BEGIN
	DROP FUNCTION UFD_TRIB_PROD_ALIQ_INTERNA
END
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20210930
'Job.................:  
'Nome................: [UFD_TRIB_PROD_ALIQ_INTERNA] 
'Objetivo............: Funo responsavel em retornar o percentual de icms com base no produto e estado
'Tabelas.............:  
'Dt Criao..........: 2022-10-27
'Dt Ult Alteraco....: 
'Alterado por........: Shirlene
'Criado por..........: Marcos barros
'=======================================================================================
Tag #20210930 - BEGIN
*/
CREATE FUNCTION [dbo].[UFD_TRIB_PROD_ALIQ_INTERNA](
											@CD_EMP		INT,
											@CD_PROD    INT,
											@UF			CHAR(2)
											)
RETURNS @RS_RETORNO TABLE(
							CD_EMP		INT, 
							CD_CTR		INT,
							CD_PROD		INT,
							PERC_ICMS	MONEY,
							UF			CHAR(2)
							) 
AS
BEGIN

INSERT INTO @RS_RETORNO 
SELECT TOP 1
	GRP.CD_EMP, 
	GRP.CD_CTR,
	GRP_PROD.CD_PROD,
	TRIB_CPL.PERC_ICMS,
	TRIB_CPL.UF
FROM 
	EST_PROD_EST_TRIB_CONF_GRP AS GRP_PROD
	INNER JOIN EST_TRIB_CONF_GRP GRP ON 
			GRP.CD_EMP			= GRP_PROD.CD_EMP AND 
			GRP.CD_CTR			= GRP_PROD.CD_CTR AND 
			GRP.FLAG_TRIB_DARE	= 0 AND
			GRP.CD_EMP			= @CD_EMP AND 
			GRP_PROD.CD_PROD	= @CD_PROD  
	INNER JOIN EST_TRIB_CONF_GRP_CPL AS TRIB_CPL ON 
			TRIB_CPL.CD_EMP		= GRP.CD_EMP AND 
			TRIB_CPL.CD_CTR		= GRP.CD_CTR AND 
			TRIB_CPL.TP_MOV		= 0 AND 
			TRIB_CPL.TP_TRANSA	= 1	AND 
			TRIB_CPL.UF			= @UF
RETURN
END




